//: ## Concurrency
//:
//: Your code executes on one queue.
//:
//: Code containing large heavy operations causes a delay to all other code that follows it.
//:
//: So, we create a new queue and execute our heavy code in a `Task`.
//:
//: -------------------
//:
//: [◀  Previous Page](@previous)  |  [Next Page  ▶](@next)
//:
//: -------------------
//:


// pretend to download a photo
struct Photo {
    let fileName: String
}

func downloadPhoto(named fileName: String) async -> Photo {
    // ... pretend to download data from internet
    // ... code pauses here until pretend download finishes
    let downloadedPhoto = Photo(fileName: fileName) // faked download
    return downloadedPhoto
}

// store each downloaded Photo to a list
func getFileNames() async -> [String] {
    // ... pretend to get filenames by reading existing files from a directory
    // ... code pauses here until pretend file search finishes
    return [
        "ByTheBeach.png",
         "DrinkingFromACoconut.png",
         "BoatTrip.png"
    ]
}


//:
//: -------------------
//:
//: ## Task
//:
//: Wrap your asyncronous code within a `Task` to add your asyncronous code to a queue on a new thread.
//:
//: -------------------
//:


// → concurrency
Task {
    let photoNames = await getFileNames(inGallery: "Summer Vacation")
    let sortedNames = photoNames.sorted()
    for each filename in sortedNames {
        let photo = await downloadPhoto(named: filename)
        // ... add to a list of downloaded files
    }
    
    // ... finished!
}


//:
//: -------------------
//:
//: [◀  Previous Page](@previous)  |  [Next Page  ▶](@next)
//:
//: -------------------
//:
//: ## ![3 Days Of Swift Logo](3DaysIcon146.png) 3 Days Of Swift
//:
//: © Copyright. All rights reserved.
//:
//: 🧕🏻🙋🏽‍♂️👨🏿‍💼👩🏼‍💼👩🏻‍💻💁🏼‍♀️👨🏼‍💼🙋🏻‍♂️🙋🏻‍♀️👩🏼‍💻🙋🏿💁🏽‍♂️🙋🏽‍♀️🙋🏿‍♀️🧕🏾🙋🏼‍♂️
//:
//: Welcome to our community of [3DaysOfSwift.com](https://www.3DaysOfSwift.com) developers!
